# HTTP

## 组件
控制器: Controller, MVC中的C
路由: Router, 将 url 配置到 Controller 中的 Action
中间件: Middleware, 处理一些前置或者后置逻辑
验证器: Validtor, 请求中的数据验证
RESTFUL: restful 风格的HTTP服务
路径：swoft/http-server/src

## 控制器
@Controller + @RequestMapping 注解实现, 前者定义 前缀, 后者定义 后缀

1、 参数设置
@Controller
@Controller(prefix="/route")
@Controller("/route")

@RequestMapping
@RequestMapping(route="index")
@RequestMapping("index")
@RequestMapping("string/{name}")
@RequestMapping(route="index", method=RequestMethod::GET) // 默认支持get, post

2、参数获取
```
// 获取所有GET参数
$get = $request->query();
// 获取name参数默认值defaultName
$getName = $request->query('name', 'defaultName');
// 获取所有POST参数
$post = $request->post();
// 获取name参数默认值defaultName
$postName = $request->post('name', 'defaultName');
// 获取所有参，包括GET或POST
$inputs = $request->input();
// 获取name参数默认值defaultName
$inputName = $request->input('name', 'defaultName');
```

## 路由器
路由解析有两种方式，注册路由和自动解析，所有路由都在routes.php中配置。
建议所有路由都提前注册，或者通过注解注册，不建议使用自动路由解析。

配置：config/beans/base.php
源码：\Swoft\Router\Http\HandlerMapping
```
'httpRouter'       => [
    'ignoreLastSep'  => false, // 是否忽略最后一个斜杠，设置false后，/user/index和/user/index/是两个不同的路由
    'tmpCacheNumber' => 1000,// 缓存路由数，最近一1000条(缓存到路由对象的，重启后失效，只会缓存动态路由)
    'matchAll'       => '', // 匹配所有
]
```

## 中间件

## 验证器
@Strings(from=ValidatorFrom::GET, name="name", min=3, max=10, default="boy")
@Number(from=ValidatorFrom::GET, name="id", min=5, max=10, default=7)
@Floats(from=ValidatorFrom::POST, name="id", min=5.1, max=5.9, default=5.6)
@Enum(from=ValidatorFrom::POST, name="name", values={1,"a",3}, default=1)

## RESTful